/**
 * SUMO UX Tracker - Preset Funnels
 * Funnels prédéfinis pour applications BtoE (Business to Employee)
 */

export const PRESET_FUNNELS = {
  // Funnel Onboarding Employé
  EMPLOYEE_ONBOARDING: {
    id: 'preset_employee_onboarding',
    name: 'Onboarding Nouvel Employé',
    description: 'Parcours d\'inscription et de configuration du compte employé',
    category: 'onboarding',
    steps: [
      {
        name: 'Accès page d\'inscription',
        detection_type: 'url',
        url_pattern: '/signup'
      },
      {
        name: 'Formulaire rempli',
        detection_type: 'click',
        element_selector: '#submit-signup'
      },
      {
        name: 'Email de confirmation cliqué',
        detection_type: 'url',
        url_pattern: '/confirm-email'
      },
      {
        name: 'Profil complété',
        detection_type: 'url',
        url_pattern: '/profile/complete'
      },
      {
        name: 'Première connexion réussie',
        detection_type: 'url',
        url_pattern: '/dashboard'
      }
    ]
  },

  // Funnel Demande de Congés
  LEAVE_REQUEST: {
    id: 'preset_leave_request',
    name: 'Demande de Congés',
    description: 'Processus de soumission d\'une demande de congés',
    category: 'workflow',
    steps: [
      {
        name: 'Accès formulaire congés',
        detection_type: 'url',
        url_pattern: '/leaves/new'
      },
      {
        name: 'Dates sélectionnées',
        detection_type: 'click',
        element_selector: '.date-picker'
      },
      {
        name: 'Formulaire soumis',
        detection_type: 'click',
        element_selector: '#submit-leave'
      },
      {
        name: 'Confirmation reçue',
        detection_type: 'url',
        url_pattern: '/leaves/confirmation'
      }
    ]
  },

  // Funnel Note de Frais
  EXPENSE_REPORT: {
    id: 'preset_expense_report',
    name: 'Note de Frais',
    description: 'Soumission d\'une note de frais',
    category: 'workflow',
    steps: [
      {
        name: 'Création note de frais',
        detection_type: 'url',
        url_pattern: '/expenses/new'
      },
      {
        name: 'Upload justificatif',
        detection_type: 'click',
        element_selector: '#upload-receipt'
      },
      {
        name: 'Montant saisi',
        detection_type: 'click',
        element_selector: '#amount-input'
      },
      {
        name: 'Note soumise',
        detection_type: 'click',
        element_selector: '#submit-expense'
      },
      {
        name: 'Confirmation affichée',
        detection_type: 'url',
        url_pattern: '/expenses/success'
      }
    ]
  },

  // Funnel Formation E-Learning
  ELEARNING_COURSE: {
    id: 'preset_elearning',
    name: 'Parcours Formation E-Learning',
    description: 'Complétion d\'un module de formation en ligne',
    category: 'training',
    steps: [
      {
        name: 'Accès catalogue formations',
        detection_type: 'url',
        url_pattern: '/training/catalog'
      },
      {
        name: 'Sélection d\'un cours',
        detection_type: 'click',
        element_selector: '.course-card'
      },
      {
        name: 'Démarrage du cours',
        detection_type: 'click',
        element_selector: '#start-course'
      },
      {
        name: 'Module 1 complété',
        detection_type: 'url',
        url_pattern: '/training/module/1/complete'
      },
      {
        name: 'Quiz final',
        detection_type: 'url',
        url_pattern: '/training/quiz'
      },
      {
        name: 'Certificat obtenu',
        detection_type: 'url',
        url_pattern: '/training/certificate'
      }
    ]
  },

  // Funnel Approbation Manager
  APPROVAL_WORKFLOW: {
    id: 'preset_approval',
    name: 'Workflow d\'Approbation',
    description: 'Processus d\'approbation par un manager',
    category: 'workflow',
    steps: [
      {
        name: 'Accès notifications',
        detection_type: 'url',
        url_pattern: '/notifications'
      },
      {
        name: 'Ouverture demande',
        detection_type: 'click',
        element_selector: '.notification-item'
      },
      {
        name: 'Détails consultés',
        detection_type: 'url',
        url_pattern: /\/request\/\d+/
      },
      {
        name: 'Décision prise (approuver/rejeter)',
        detection_type: 'click',
        element_selector: '.btn-approve, .btn-reject'
      },
      {
        name: 'Confirmation',
        detection_type: 'url',
        url_pattern: '/request/processed'
      }
    ]
  },

  // Funnel Support Ticket
  SUPPORT_TICKET: {
    id: 'preset_support',
    name: 'Création Ticket Support IT',
    description: 'Processus de création et suivi d\'un ticket support',
    category: 'support',
    steps: [
      {
        name: 'Accès support',
        detection_type: 'url',
        url_pattern: '/support'
      },
      {
        name: 'Nouveau ticket',
        detection_type: 'click',
        element_selector: '#new-ticket'
      },
      {
        name: 'Catégorie sélectionnée',
        detection_type: 'click',
        element_selector: '.category-select'
      },
      {
        name: 'Description remplie',
        detection_type: 'click',
        element_selector: '#description'
      },
      {
        name: 'Ticket soumis',
        detection_type: 'click',
        element_selector: '#submit-ticket'
      },
      {
        name: 'Numéro de ticket reçu',
        detection_type: 'url',
        url_pattern: /\/ticket\/\d+/
      }
    ]
  }
};

/**
 * Retourne tous les funnels prédéfinis
 */
export function getAllPresetFunnels() {
  return Object.values(PRESET_FUNNELS);
}

/**
 * Retourne les funnels par catégorie
 */
export function getPresetFunnelsByCategory(category) {
  return getAllPresetFunnels().filter(f => f.category === category);
}

/**
 * Retourne un funnel prédéfini par ID
 */
export function getPresetFunnel(presetId) {
  return Object.values(PRESET_FUNNELS).find(f => f.id === presetId);
}
