# 📊 SUMO UX Tracker - Application d'Analyse

Application web pour analyser les sessions utilisateur capturées par l'extension Chrome SUMO UX Tracker.

## 🚀 Démarrage Rapide

### 1. Lancer l'application

**Option A : Double-clic**
```bash
Ouvrir index.html dans votre navigateur
```

**Option B : Serveur local**
```bash
# Python 3
python -m http.server 8000

# Puis ouvrir : http://localhost:8000
```

### 2. Importer une session

1. Glisser-déposer un fichier `.uxtrack` dans la zone d'import
2. Ou cliquer "Parcourir" pour sélectionner un fichier
3. La session apparaît dans la liste automatiquement

### 3. Analyser

Cliquer sur une session pour accéder à :
- **📹 Replay** : Revoir le parcours utilisateur
- **🔥 Heatmap** : Visualiser les zones chaudes (clics, souris, scroll)
- **📊 Analytics** : Métriques et insights automatiques

---

## 📦 Fonctionnalités

### ✅ Import Sessions
- Drag & drop fichiers .uxtrack
- Parsing automatique (JSON + screenshots)
- Stockage local persistant (IndexedDB)
- Validation des données

### ✅ Liste Sessions
- Cards avec thumbnail
- Recherche par URL
- Tri (date, durée)
- Badges rage clicks

### ✅ Replay
- Lecteur vidéo-like
- Timeline interactive
- Play/Pause/Vitesse (0.5x à 4x)
- Event markers (clics, rage clicks, navigation)

### ✅ Heatmaps
- 3 couches : Clics (rouge), Mouvements (orange), Scroll (bleu)
- Toggle couches individuellement
- Slider opacité
- Canvas 2D performant

### ✅ Analytics
- 7 métriques clés (durée, clics, engagement...)
- Insights automatiques (frustrations, patterns)
- Messages actionnables

---

## 🛠️ Stack Technique

- **Vanilla JavaScript ES6+** (pas de framework)
- **CSS3** (Grid + Flexbox)
- **IndexedDB** (stockage local)
- **Canvas 2D** (heatmaps)
- **JSZip** (parsing .uxtrack)

**Aucune dépendance** (sauf JSZip chargé à la demande via CDN)

---

## 📁 Structure

```
sumo-ux-app/
├── index.html          # Point d'entrée
├── css/
│   ├── base.css       # Variables + reset
│   ├── layout.css     # Structure
│   ├── sessions.css   # Import + liste
│   ├── replay.css     # Lecteur
│   └── heatmap.css    # Heatmaps + analytics
└── js/
    ├── main.js        # Orchestrateur
    ├── db.js          # IndexedDB
    ├── import.js      # Parser .uxtrack
    ├── sessions.js    # Gestion liste
    ├── replay.js      # Lecteur
    ├── heatmap.js     # Génération heatmaps
    └── analytics.js   # Métriques
```

**Total :** 13 fichiers, ~2800 lignes

---

## 🔧 Configuration

**Aucune configuration nécessaire !**

L'app fonctionne directement après ouverture de `index.html`.

### Compatibilité

- ✅ Chrome 90+
- ✅ Firefox 88+
- ✅ Edge 90+
- ✅ Safari 14+

**Prérequis :** Navigateur moderne avec support IndexedDB et Canvas

---

## 📖 Guide d'Utilisation

### Import d'une session

1. Utiliser l'extension Chrome pour capturer une session
2. Exporter en `.uxtrack` depuis l'extension
3. Dans l'app web : glisser le fichier dans la zone d'import
4. ✅ Session importée et visible dans la liste

### Analyse d'une session

**Replay :**
- Cliquer ▶️ pour lancer
- Cliquer sur timeline pour seek
- Changer vitesse (0.5x, 1x, 2x, 4x)

**Heatmap :**
- Cocher/décocher couches (Clics, Mouvements, Scroll)
- Ajuster opacité avec le slider
- Canvas montre zones d'interaction

**Analytics :**
- Voir métriques (durée, clics, engagement)
- Lire insights automatiques
- Identifier points de friction

---

## 🐛 Dépannage

### La session ne s'importe pas
- ✅ Vérifier que le fichier est bien un `.uxtrack` ou `.zip`
- ✅ Vérifier que le fichier contient `session-data.json`
- ✅ Regarder la console navigateur (F12) pour erreurs

### Les screenshots ne s'affichent pas
- ✅ Vérifier que le ZIP contient `screenshots/*.webp`
- ✅ Recharger la page (F5)

### IndexedDB ne fonctionne pas
- ✅ Ne pas utiliser mode navigation privée
- ✅ Vérifier que IndexedDB est activé dans les paramètres navigateur

### L'app est lente
- ✅ Trop d'événements (>5000) peut ralentir les heatmaps
- ✅ Fermer d'autres onglets
- ✅ Désactiver couches heatmap non nécessaires

---

## 📝 Notes

### Stockage
- Les sessions sont stockées dans **IndexedDB** du navigateur
- Les données persistent entre les sessions
- Nettoyer avec les outils développeur (Application > IndexedDB)

### Limitations
- Pas de comparaison A/B (v1)
- Pas d'export PDF (v1)
- Pas d'annotations manuelles (v1)
- Timeline markers sans tooltips détaillés

---

## 🎯 Roadmap v2

- [ ] Export rapport PDF
- [ ] Comparaison sessions A/B
- [ ] Annotations sur timeline
- [ ] Filtres avancés (date, durée, rage clicks)
- [ ] Dashboard multi-sessions

---

## 📄 Licence

Projet SUMO UX Tracker V3 - Application d'analyse

---

## 🙋 Support

**Questions ou problèmes ?**
- Consulter le fichier `US-201-recap.md` pour documentation complète
- Vérifier la console navigateur pour erreurs
- Tester avec un fichier .uxtrack valide

---

**Version :** 1.0.0  
**Date :** 08/11/2025  
**Status :** ✅ MVP Fonctionnel
