/**
 * SUMO UX Tracker V3 - Constants
 */

window.SUMO_CONSTANTS = {
  // Triggers de screenshots
  SCREENSHOT_TRIGGERS: {
    INITIAL: 'initial',
    PAGE_LOAD: 'page_load',
    CLICK_AFTER: 'click_after',
    NAVIGATION: 'navigation_change',
    PATTERN_RAGE: 'pattern_rage_click',
    PATTERN_DEAD: 'pattern_dead_click'
  },
  
  // Délais
  DELAYS: {
    SCREENSHOT_AFTER_CLICK: 2000,  // 2 secondes après clic
    URL_CHECK_INTERVAL: 200,        // Vérifier URL tous les 200ms
    BATCH_TIMEOUT: 5000             // Envoyer events tous les 5s
  },
  
  // Seuils patterns
  PATTERNS: {
    RAGE_CLICK_COUNT: 5,            // 5 clics rapides
    RAGE_CLICK_RADIUS: 50,          // Dans 50px
    RAGE_CLICK_TIME: 2000,          // En 2 secondes
    HESITATION_THRESHOLD: 3000,     // 3 secondes sans mouvement
    DEAD_CLICK_WAIT: 1000           // 1 seconde sans changement
  },
  
  // Export
  EXPORT: {
    VERSION: '3.0.0',
    SCREENSHOT_QUALITY: 0.85,
    SCREENSHOT_FORMAT: 'image/jpeg'
  }
};
