# 📝 SUMO UX Tracker V3 - Mode Feedback

## 🎯 Vue d'ensemble

Le **Mode Feedback** permet aux utilisateurs de donner du feedback visuel directement sur la page web en cours de test, grâce à des outils d'annotation en surimppression.

---

## ✨ Fonctionnalités

### 🎨 Outils d'annotation
- **✏️ Dessin libre** : Tracer des annotations à main levée
- **➡️ Flèches** : Pointer des éléments spécifiques
- **📝 Post-it** : Ajouter des notes textuelles
- **🔴 Zones de surbrillance** : Marquer des zones importantes

### 🎨 Personnalisation
- **5 couleurs** : Rouge, Vert, Bleu, Violet SUMO, Jaune
- **Annulation** : Ctrl+Z ou bouton Annuler
- **Effacement total** : Bouton Effacer

---

## 🚀 Utilisation

### 1. Activer le mode Feedback
1. Démarrer une session de tracking
2. Cliquer sur le bouton **"📝 Feedback Mode"** dans le popup
3. La page se fige et un canvas transparent apparaît

### 2. Annoter la page
1. Choisir un outil dans la toolbar flottante en bas
2. Dessiner, pointer, ou ajouter des notes
3. Changer de couleur si besoin
4. Utiliser **Annuler** pour corriger une erreur

### 3. Sauvegarder
1. Cliquer sur **"✅ Valider"** pour sauvegarder
2. Les annotations sont stockées dans la session
3. Le mode Feedback se ferme automatiquement

### 4. Annuler
- Cliquer sur **"❌ Annuler"** pour quitter sans sauvegarder

---

## 📦 Structure des données

### Format de stockage
```json
{
  "feedbackId": "fb-1737104400000",
  "timestamp": "2025-01-17T10:00:00.000Z",
  "url": "https://example.com/page",
  "viewport": {
    "width": 1920,
    "height": 1080,
    "scrollX": 0,
    "scrollY": 250
  },
  "annotations": [
    {
      "type": "drawing",
      "color": "#FF0000",
      "strokeWidth": 3,
      "points": [
        {"x": 100, "y": 200},
        {"x": 105, "y": 205}
      ]
    },
    {
      "type": "postit",
      "x": 300,
      "y": 400,
      "width": 200,
      "height": 150,
      "text": "Ce bouton est trop petit",
      "color": "#FFF59D"
    },
    {
      "type": "arrow",
      "startX": 500,
      "startY": 300,
      "endX": 550,
      "endY": 350,
      "color": "#9800F3",
      "strokeWidth": 4
    },
    {
      "type": "highlight",
      "startX": 100,
      "startY": 100,
      "endX": 400,
      "endY": 300,
      "color": "#00FF00"
    }
  ]
}
```

---

## 🔧 Architecture technique

### Fichiers
```
v3/feedback/
├── feedback-overlay.js    // Core: overlay canvas + outils
├── feedback.css           // Styles toolbar et overlay
└── FEEDBACK-README.md     // Cette documentation
```

### Flux de données
```
1. Popup → Content Script : enableFeedbackMode
2. Content Script → Création overlay + gel page
3. Utilisateur → Dessine annotations
4. Content Script → Background : saveFeedback
5. Background → Stockage dans session.feedbacks[]
6. Export → session-data.json inclut feedbacks
```

---

## 🎨 Interface utilisateur

### Toolbar flottante (en bas de l'écran)
```
┌────────────────────────────────────────────────────────┐
│ [✏️] [➡️] [📝] [🔴] │ [⚪⚪⚪⚪⚪] │ [↶] [🗑️] │ [❌] [✅] │
│  Outils           │  Couleurs  │  Actions │  Validation │
└────────────────────────────────────────────────────────┘
```

### États des boutons
- **Outil actif** : Fond blanc + ombre
- **Couleur active** : Bordure blanche épaisse
- **Hover** : Scale + ombre
- **Validation** : Animation scale sur hover

---

## 🎯 Cas d'usage

### 1. Signaler un bug visuel
1. Activer Feedback Mode
2. Dessiner un cercle rouge autour du bug
3. Ajouter un post-it : "Le texte est coupé"
4. Valider

### 2. Suggérer une amélioration
1. Activer Feedback Mode
2. Flèche violette vers l'élément
3. Post-it : "Bouton trop petit, augmenter à 48px"
4. Valider

### 3. Marquer une zone problématique
1. Activer Feedback Mode
2. Zone de surbrillance rouge
3. Post-it : "Cette section est confuse"
4. Valider

---

## 🔒 Sécurité

- ✅ **Pas de screenshot** : Seulement coordonnées + texte
- ✅ **localStorage sécurisé** : Chrome.storage.local
- ✅ **Pas de serveur** : Tout est local
- ✅ **Isolation** : Overlay ne peut pas interagir avec la page

---

## 📊 Compatibilité

### Navigateurs
- ✅ Chrome 88+
- ✅ Edge 88+
- ⚠️ Firefox (en cours)
- ❌ Safari (non supporté)

### Pages
- ✅ Sites web classiques
- ✅ Applications web (React, Vue, etc.)
- ✅ Prototypes Figma
- ❌ Pages chrome://
- ❌ Pages chrome-extension://

---

## 🐛 Troubleshooting

### Le mode Feedback ne s'active pas
- **Cause** : Content script pas chargé
- **Solution** : Rafraîchir la page et réessayer

### Les annotations disparaissent
- **Cause** : Pas validé avant de fermer
- **Solution** : Toujours cliquer sur "✅ Valider"

### Le canvas est décalé
- **Cause** : Page scrollée après activation
- **Solution** : Ne pas scroller pendant l'annotation

### Les couleurs ne changent pas
- **Cause** : Bouton couleur pas cliqué
- **Solution** : Bien cliquer sur le bouton couleur

---

## 🚀 Améliorations futures (V4)

- [ ] **Gomme** : Effacer partiellement
- [ ] **Formes** : Rectangle, cercle, ligne
- [ ] **Texte libre** : Écrire sans post-it
- [ ] **Screenshot optionnel** : Capturer avec annotations
- [ ] **Replay** : Rejouer les annotations dans l'app
- [ ] **Export PDF** : Annotations en PDF
- [ ] **Partage** : Partager un feedback
- [ ] **Collaborative** : Feedback multi-utilisateurs

---

## 📝 Notes développeur

### Événements clés
- `mousedown` : Début annotation
- `mousemove` : Dessin en cours
- `mouseup` : Fin annotation
- `Ctrl+Z` : Annuler
- `Escape` : Quitter

### Performance
- **Canvas** : Hardware accelerated
- **Render** : requestAnimationFrame
- **Storage** : Async chrome.storage
- **Memory** : ~5MB max par session

### Debug
```javascript
// Console dans background.js
chrome.runtime.sendMessage({action: 'saveFeedback'})

// Console dans content script
FeedbackOverlay.annotations
```

---

## 📄 Licence

© 2025 SUMO UX Tracker - Usage interne

---

**Version** : 3.0.0
**Date** : Janvier 2025
**Auteur** : SUMO Team
