/**
 * SUMO UX Tracker V3 - Time Tracker
 * Track time spent on page
 */

class TimeTracker {
  constructor(callback) {
    this.callback = callback;
    this.startTime = null;
    this.enabled = false;
    this.intervalId = null;
  }
  
  start() {
    if (this.enabled) return;
    this.enabled = true;
    this.startTime = Date.now();
    
    // Envoyer update toutes les 10 secondes
    this.intervalId = setInterval(() => {
      if (this.enabled) {
        this.callback({
          type: 'time_update',
          timestamp: Date.now(),
          duration: Date.now() - this.startTime
        });
      }
    }, 10000);
    
    console.log('[TimeTracker] Started');
  }
  
  stop() {
    this.enabled = false;
    if (this.intervalId) {
      clearInterval(this.intervalId);
      this.intervalId = null;
    }
    
    // Envoyer durée finale
    if (this.startTime) {
      this.callback({
        type: 'time_final',
        timestamp: Date.now(),
        duration: Date.now() - this.startTime
      });
    }
    
    console.log('[TimeTracker] Stopped');
  }
  
  getDuration() {
    return this.startTime ? Date.now() - this.startTime : 0;
  }
  
  getStats() {
    return {
      duration: this.getDuration(),
      startTime: this.startTime
    };
  }
}

// Exposer globalement
window.TimeTracker = TimeTracker;
