/**
 * SUMO UX Tracker V3 - Mouse Tracker
 * Capture mouvements de souris (throttled)
 */

class MouseTracker {
  constructor(callback) {
    this.callback = callback;
    this.enabled = false;
    this.lastSampleTime = 0;
    this.sampleRate = 100; // 1 sample tous les 100ms
    this.moveCount = 0;
    
    this.handleMouseMove = this.handleMouseMove.bind(this);
  }
  
  start() {
    if (this.enabled) return;
    this.enabled = true;
    document.addEventListener('mousemove', this.handleMouseMove, { passive: true });
    console.log('[MouseTracker] Started');
  }
  
  stop() {
    this.enabled = false;
    document.removeEventListener('mousemove', this.handleMouseMove);
    console.log('[MouseTracker] Stopped');
  }
  
  handleMouseMove(event) {
    if (!this.enabled) return;
    
    const now = Date.now();
    
    // Throttle: 1 sample tous les 100ms
    if (now - this.lastSampleTime < this.sampleRate) return;
    
    this.lastSampleTime = now;
    this.moveCount++;
    
    this.callback({
      type: 'mouse_move',
      timestamp: now,
      x: event.clientX,
      y: event.clientY,
      pageX: event.pageX,
      pageY: event.pageY
    });
  }
  
  getStats() {
    return {
      totalMoves: this.moveCount
    };
  }
}

// Exposer globalement
window.MouseTracker = MouseTracker;
