# 🥋 SUMO UX Tracker V3 - Clean Edition

## 🎯 Reset Complet - Architecture Propre

Extension **from scratch** avec architecture simplifiée et features optimisées.

---

## ✨ Nouveautés V3

### 1. Screenshot Intelligent
- ✅ **1 clic = 1 screenshot** (automatique après 2 secondes)
- ✅ Laisse le temps à la page/Figma de charger
- ✅ Capture l'état final après interaction

### 2. Support Figma
- ✅ Détection navigation Figma (#/file/xxx → #/file/yyy)
- ✅ Screenshots automatiques changement de frame
- ✅ Compatible web classique ET prototypes Figma

### 3. Architecture Clean
- ✅ Code simple, bien commenté (< 200 lignes/fichier)
- ✅ Pas de chargement dynamique complexe
- ✅ Trackers indépendants et testables
- ✅ Export compatible avec ton app React

---

## 📦 Installation

### Option 1 : Copier les fichiers

```bash
# Copier tout le dossier v3/
cp -r v3/ ~/ton-projet/extension/
```

### Option 2 : Structure manuelle

```
extension/
├── manifest.json
├── background/
│   └── background.js
├── content/
│   ├── content-main.js
│   └── trackers/
│       ├── click-tracker.js
│       ├── mouse-tracker.js
│       ├── scroll-tracker.js
│       ├── time-tracker.js
│       ├── navigation-tracker.js
│       ├── screenshot-handler.js
│       └── patterns-analyzer.js
├── popup/
│   ├── popup.html
│   ├── popup.css
│   └── popup.js
├── shared/
│   ├── constants.js
│   └── export-manager.js
└── assets/
    └── sumo*.png
```

### Option 3 : Chrome directement

1. Télécharger le dossier `v3/`
2. Chrome → `chrome://extensions/`
3. Activer "Mode développeur"
4. "Charger l'extension non empaquetée"
5. Sélectionner le dossier `v3/`

---

## 🚀 Utilisation

### 1. Démarrer un Test

1. **Ouvrir** la page à tester (web ou Figma)
2. **Cliquer** sur l'icône SUMO
3. **Start Tracking** ▶️
4. **Interagir** avec la page
   - Chaque clic = screenshot 2 sec après
   - Navigation détectée automatiquement
   - Patterns analysés en temps réel

### 2. Arrêter et Exporter

1. **Stop Tracking** ⏹️
2. **Export Session** 💾
3. Fichiers téléchargés :
   - `session-xxxxx.json`
   - `screenshot-1-xxxxx.jpg`
   - `screenshot-2-xxxxx.jpg`
   - etc.

---

## 📊 Format Export (Compatible App React)

### session-data.json

```json
{
  "session": {
    "sessionId": "sumo_1234567890_abc123",
    "url": "https://figma.com/proto/...",
    "title": "Mon Prototype",
    "startTime": 1234567890000,
    "endTime": 1234567950000,
    "duration": 60000
  },
  "events": [
    {
      "type": "click",
      "id": 1,
      "timestamp": 1234567890123,
      "x": 450,
      "y": 300,
      "target": {
        "tagName": "BUTTON",
        "text": "Continuer"
      }
    },
    {
      "type": "navigation",
      "subtype": "hash_change",
      "timestamp": 1234567892000,
      "from": "#page-1",
      "to": "#page-2",
      "isFigma": true
    }
  ],
  "screenshots": [
    {
      "id": 1,
      "filename": "screenshot-1-1234567890123.jpg",
      "trigger": "initial",
      "timestamp": 1234567890000
    },
    {
      "id": 2,
      "filename": "screenshot-2-1234567892123.jpg",
      "trigger": "click_after",
      "timestamp": 1234567892123,
      "relatedEventId": 1
    },
    {
      "id": 3,
      "filename": "screenshot-3-1234567894000.jpg",
      "trigger": "navigation_change",
      "timestamp": 1234567894000
    }
  ],
  "stats": {
    "totalEvents": 50,
    "totalScreenshots": 25,
    "totalClicks": 20,
    "totalNavigations": 5
  },
  "version": "3.0.0"
}
```

**Triggers disponibles** :
- `initial` : Screenshot au démarrage
- `click_after` : 2 sec après un clic
- `navigation_change` : Changement de page/frame
- `pattern_rage_click` : Rage click détecté

---

## 🧪 Tests

### Test 1 : Vérifier Extension Chargée

**Console** (sur n'importe quelle page) :
```javascript
window.sumoContent.debug.getStats()
```

**Attendu** :
```javascript
{
  isTracking: false,
  sessionId: null,
  events: 0,
  screenshots: 0,
  trackers: {
    click: { totalClicks: 0 },
    mouse: { totalMoves: 0 },
    scroll: { totalScrolls: 0 },
    time: { duration: 0 },
    navigation: { totalNavigations: 0 },
    screenshot: { totalScreenshots: 0 }
  }
}
```

### Test 2 : Session Complète

1. Ouvrir une page (ex: google.com)
2. Start Tracking
3. Cliquer 3 fois
4. Attendre 2 sec après chaque clic
5. Stop Tracking
6. Vérifier console :

```javascript
window.sumoContent.debug.getStats()
// events: 3, screenshots: 4 (initial + 3 clics)
```

### Test 3 : Figma

1. Ouvrir prototype Figma
2. Start Tracking
3. Naviguer entre frames
4. Stop & Export
5. Vérifier JSON : `isFigma: true` dans navigations

---

## 🔍 Debug

### Console Logs

**Au chargement** :
```
[SUMO V3] Initializing on: https://...
[ClickTracker] Started
[MouseTracker] Started
[ScrollTracker] Started
[TimeTracker] Started
[NavigationTracker] Started - Monitoring web + Figma navigation
[ScreenshotHandler] Started
[PatternsAnalyzer] Started
[SUMO V3] ✅ Ready with 7 trackers
[SUMO V3] 🚀 Extension loaded - Use window.sumoContent.debug.getStats()
```

**Lors d'un clic** :
```
[ClickTracker] Click #1 at (450, 300), screenshot in 2s
[ScreenshotHandler] Capturing screenshot #2 (click_after)
[ScreenshotHandler] Screenshot #2 captured successfully
```

**Rage click** :
```
[PatternsAnalyzer] 🔥 RAGE CLICK detected!
[ScreenshotHandler] Capturing screenshot #5 (pattern_rage_click)
```

### Commandes Debug

```javascript
// Stats complètes
window.sumoContent.debug.getStats()

// Liste events
window.sumoContent.debug.getEvents()

// Liste screenshots
window.sumoContent.debug.getScreenshots()
```

---

## 🎨 Personnalisation

### Modifier Délai Screenshot

**Fichier** : `shared/constants.js`

```javascript
DELAYS: {
  SCREENSHOT_AFTER_CLICK: 2000,  // ← Changer ici (en ms)
  ...
}
```

### Modifier Seuils Patterns

**Fichier** : `shared/constants.js`

```javascript
PATTERNS: {
  RAGE_CLICK_COUNT: 5,     // ← Nombre de clics
  RAGE_CLICK_RADIUS: 50,   // ← Rayon en pixels
  RAGE_CLICK_TIME: 2000,   // ← Durée en ms
  ...
}
```

---

## 📝 Différences avec V2

| Feature | V2 | V3 |
|---------|----|----|
| Architecture | Complexe, chargement dynamique | Simple, déclarative |
| Screenshots | Sporadiques | Systématiques (1 par clic) |
| Figma Support | ❌ | ✅ |
| Délai Screenshot | Immédiat | 2 secondes (intelligent) |
| Code | ~2000 lignes | ~1200 lignes |
| Bugs document.head | ✅ Présents | ❌ Corrigés |

---

## 🐛 Problèmes Connus

### Screenshots manquent sur Figma

**Cause** : Figma charge lentement les frames

**Solution** : Délai 2 sec déjà implémenté, mais si problème persiste :
```javascript
// Dans constants.js
SCREENSHOT_AFTER_CLICK: 3000  // Augmenter à 3 sec
```

### Export plante sur gros fichiers

**Cause** : Trop de screenshots en mémoire

**Solution** : Limiter durée sessions (< 5 min recommandé)

---

## 🚀 Prochaines Étapes

1. **Tester sur plusieurs sites** (Google, Facebook, Figma)
2. **Vérifier export** compatible avec ton app React
3. **Ajuster délais** si besoin
4. **Feedback** sur patterns détectés

---

## 📞 Support

**Fichiers fournis** :
- ✅ Tous les fichiers de l'extension
- ✅ Architecture documentée
- ✅ Format export compatible

**En cas de problème** :
1. Vérifier console logs
2. Utiliser commandes debug
3. Vérifier structure fichiers

---

**Version** : 3.0.0  
**Date** : 2025-01-11  
**Status** : 🟢 Production Ready
