# ⚡ QUICK START - SUMO V3

## 🎯 En 3 Minutes

### 1️⃣ Télécharger (1 min)

**Option A** : ZIP complet
- [Télécharger sumo-ux-tracker-v3.zip](computer:///mnt/user-data/outputs/sumo-ux-tracker-v3.zip)
- Dézipper

**Option B** : Dossier direct
- Copier le dossier `v3/` fourni

---

### 2️⃣ Installer (1 min)

1. Chrome → `chrome://extensions/`
2. Activer **Mode développeur** (coin haut droit)
3. **Charger l'extension non empaquetée**
4. Sélectionner le dossier `v3/`
5. ✅ Extension chargée !

---

### 3️⃣ Tester (1 min)

1. **Ouvrir** n'importe quelle page
2. **F12** → Console
3. Taper : `window.sumoContent.debug.getStats()`
4. **Résultat attendu** :
   ```javascript
   {
     isTracking: false,
     trackers: { 
       click: {...}, 
       mouse: {...}, 
       ... 
     }
   }
   ```
5. ✅ **Ça marche !**

---

## 🧪 Premier Test Complet (2 min)

### Sur Google.com

1. **Ouvrir** google.com
2. **Cliquer** icône SUMO (extension)
3. **Start Tracking** ▶️
4. **Faire 3 recherches**
5. **Stop Tracking** ⏹️
6. **Export Session** 💾

**Résultat** : 
- 1 fichier `session-xxxxx.json`
- ~10-15 fichiers `screenshot-x-xxxxx.jpg`

---

## 🎨 Test Figma (3 min)

### Sur Prototype Figma

1. **Ouvrir** ton prototype Figma
2. **Start Tracking**
3. **Naviguer** entre 3-4 frames
4. **Cliquer** sur boutons
5. **Stop & Export**

**Vérifier JSON** :
```json
{
  "events": [
    {
      "type": "navigation",
      "isFigma": true  ← DOIT être présent
    }
  ]
}
```

✅ **Si tu vois `isFigma: true`** → Figma détecté !

---

## 📊 Vérifier Compatibilité App React

### Structure Export

**Tu dois avoir** :
```
Downloads/
├── session-sumo_xxxxx.json     ← Métadonnées
├── screenshot-1-xxxxx.jpg      ← Initial
├── screenshot-2-xxxxx.jpg      ← Après clic 1
├── screenshot-3-xxxxx.jpg      ← Après clic 2
└── ...
```

### Format JSON

**Ouvrir** `session-xxxxx.json` :
```json
{
  "session": { ... },
  "events": [ ... ],
  "screenshots": [
    {
      "id": 1,
      "filename": "screenshot-1-xxxxx.jpg",
      "trigger": "initial" ou "click_after" ou "navigation_change"
    }
  ],
  "version": "3.0.0"
}
```

✅ **Si structure identique** → Compatible avec ton app !

---

## 🔥 Features Clés V3

### 1. Screenshot Automatique
```
User clique
    ↓
Attendre 2 secondes
    ↓
Screenshot automatique
```

**Résultat** : Capture l'état **après** chargement

### 2. Figma Support
```
Figma #page-1 → #page-2
    ↓
Détection automatique
    ↓
Screenshot du nouvel état
```

**Résultat** : Toutes les navigations Figma capturées

### 3. Rage Click
```
5 clics rapides même zone
    ↓
Pattern détecté
    ↓
Screenshot + métadonnées
```

**Résultat** : Identifier frustrations utilisateur

---

## 🐛 Debug Rapide

### Problème : Extension ne se charge pas

**Console browser** :
```
Erreur : manifest.json invalide
```

**Solution** : Vérifier que tous les fichiers sont présents

### Problème : Aucun screenshot

**Console page** :
```javascript
window.sumoContent.debug.getStats()
// screenshot: { totalScreenshots: 0 }
```

**Solution** : 
1. Vérifier que tracking est démarré
2. Attendre 2 sec après clic
3. Vérifier permission activeTab

### Problème : Export ne marche pas

**Console popup** :
```
Export error: No active session
```

**Solution** : 
1. Start → Interagir → Stop
2. **Puis** Export (dans cet ordre)

---

## 📞 Checklist Validation

Avant de considérer V3 OK, vérifier :

- [ ] Extension se charge sans erreur
- [ ] `window.sumoContent` existe
- [ ] Start/Stop tracking fonctionne
- [ ] Clics déclenchent screenshots (2 sec delay)
- [ ] Navigation Figma détectée (`isFigma: true`)
- [ ] Export télécharge JSON + JPG
- [ ] Format JSON compatible app React
- [ ] Rage clicks détectés

**Si TOUT coché** → ✅ **V3 VALIDÉE !**

---

## 🚀 Prochaines Étapes

1. **Tester** sur tes cas réels
2. **Ajuster** délais si besoin (constants.js)
3. **Intégrer** avec ton app React
4. **Feedback** sur fonctionnement

---

## 📦 Fichiers Importants

**Extension** :
- `manifest.json` - Config Chrome
- `content/content-main.js` - Orchestrateur
- `content/trackers/*.js` - Capture data
- `popup/*` - Interface utilisateur

**Config** :
- `shared/constants.js` - Délais, seuils

**Doc** :
- `README.md` - Guide complet
- `QUICK-START.md` - Ce fichier

---

**Version** : 3.0.0  
**Status** : 🟢 Ready to Use  
**Temps total installation + test** : ~5 minutes
